/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rule;

import java.io.Serializable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.internal.google.common.base.Strings;

@Immutable
public class RuleKey
implements Serializable {
    public static final String MANUAL_REPOSITORY_KEY = "manual";
    private final String repository;
    private final String rule;

    protected RuleKey(String repositoryKey, String ruleKey) {
        this.repository = repositoryKey;
        this.rule = ruleKey;
    }

    public static RuleKey of(String repository, String rule) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(repository), "Repository must be set");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(rule), "Rule must be set");
        return new RuleKey(repository, rule);
    }

    public static RuleKey parse(String s) {
        int semiColonPos = s.indexOf(":");
        Preconditions.checkArgument(semiColonPos > 0, "Invalid rule key: " + s);
        String key = s.substring(0, semiColonPos);
        String repo = s.substring(semiColonPos + 1);
        return RuleKey.of(key, repo);
    }

    public String repository() {
        return this.repository;
    }

    public String rule() {
        return this.rule;
    }

    public boolean isManual() {
        return MANUAL_REPOSITORY_KEY.equals(this.repository);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleKey ruleKey = (RuleKey)o;
        if (!this.repository.equals(ruleKey.repository)) {
            return false;
        }
        return this.rule.equals(ruleKey.rule);
    }

    public int hashCode() {
        int result = this.repository.hashCode();
        result = 31 * result + this.rule.hashCode();
        return result;
    }

    public String toString() {
        return String.format("%s:%s", this.repository, this.rule);
    }
}

